///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool OpenLogFile(void)
{
    char FullFileName[256];

    SYSTEMTIME ST;

    GetLocalTime(&ST);

    char DateTemp[64 + 1];

    GetDateFormat(LOCALE_USER_DEFAULT, NULL, &ST, "MM-dd-yy", DateTemp,64);

    sprintf(FullFileName, "%s\\%s.txt", gsSessionLogDir, DateTemp);

    if( (gfSessionLog = fopen(FullFileName, "ab")) == NULL)
        return false;

    return true;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool Initialize(void)
{
    if(!GetRegistryValues())
    {
		FatalError("Error getting registry values!");
        glErrorCount++;
        return false;
    }

    if(!OpenLogFile())
    {
        FatalError("Failed to open log file");
        glErrorCount++;
        return false;
    }

    InitializeCRCTable();

    // -----------------------------------------------------

    if(!InitCryptography())
    {
		FatalError("Error initializing cryptography!");
        glErrorCount++;
        return false;
    }

    if(!InitClientInfo())
    {
		FatalError("Error initializing cleint info!");
        glErrorCount++;
        return false;
    }

    return true;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool Uninitialize(void)
{
    if(!UninitCryptography())
        return false;

    if(!UnInitClientInfo())
        return false;

    if(gfSessionLog) fclose(gfSessionLog);

    return true;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

